/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.infernomobs.block;

import com.lycanitesmobs.core.block.BlockFluidBase;
import com.lycanitesmobs.infernomobs.InfernoMobs;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidPureLava
extends BlockFluidBase {
    public BlockFluidPureLava(Fluid fluid) {
        super(fluid, Material.field_151587_i, InfernoMobs.group, "purelava");
        this.func_149713_g(1);
        this.func_149715_a(1.0f);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == this) {
            if (blockState.func_177230_c().func_176201_c(blockState) != 0) {
                int otherSourceBlocks = 0;
                ArrayList<BlockPos> adjBlockPositions = new ArrayList<BlockPos>();
                adjBlockPositions.add(pos.func_177982_a(-1, 0, 0));
                adjBlockPositions.add(pos.func_177982_a(1, 0, 0));
                adjBlockPositions.add(pos.func_177982_a(0, 1, 0));
                adjBlockPositions.add(pos.func_177982_a(0, 0, -1));
                adjBlockPositions.add(pos.func_177982_a(0, 0, 1));
                for (BlockPos adjBlockPos : adjBlockPositions) {
                    IBlockState adjBlockState = world.func_180495_p(adjBlockPos);
                    Block adjBlock = adjBlockState.func_177230_c();
                    int adjMetadata = adjBlock.func_176201_c(adjBlockState);
                    if (adjBlock == this && adjMetadata == 0) {
                        otherSourceBlocks = (byte)(otherSourceBlocks + 1);
                    }
                    if (otherSourceBlocks <= true) continue;
                    break;
                }
                if (otherSourceBlocks > 1 && world instanceof World) {
                    ((World)world).func_175656_a(pos, this.func_176223_P());
                }
            }
            return false;
        }
        if (blockState == Blocks.field_150355_j) {
            if (world instanceof World) {
                ((World)world).func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
            }
            return false;
        }
        if (blockState.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return this.canDisplace((IBlockAccess)world, pos);
        }
        return super.displaceIfPossible(world, pos);
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            entity.func_70097_a(DamageSource.field_76371_c, 10.0f);
        }
        super.func_180634_a(world, pos, state, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState blockState, World world, BlockPos pos, Random random) {
        if (random.nextInt(100) == 0) {
            float f = (float)pos.func_177958_n() + random.nextFloat();
            float f1 = (float)pos.func_177956_o() + random.nextFloat() * 0.5f;
            float f2 = (float)pos.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.LAVA, (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        super.func_180655_c(blockState, world, pos, random);
    }
}

